Scriptname SuH_actiS_replicate extends ObjectReference  

SuH_Fun property _f auto
SuH_Status property _s auto

Event OnInit()
	_f = Game.GetFormFromFile(0x814, "Succubus Heart.esp") as SuH_Fun
	_s = Game.GetFormFromFile(0x16E496, "Succubus Heart.esp") as SuH_Status
endEvent

Event OnActivate(ObjectReference akActionRef)
	; Sanity Check (check if there are items in the replication chest, if not we clean some variables so stuff doesn't show up incorrectly)
	int chestitemcount = _s.SuH_cont_repchest.GetItemCount(_s.SuH_realm_talireitem)
	if chestitemcount == 0 || chestitemcount == 1 && _s.SuH_cont_repchest.GetNthForm(0) == _s.Gold001 ; Check if no items or if the only item is gold
		_s.SuH_realm_talireitem = none ; Set item to none so it doesn't show up in menu
	endIf
	
	int bloodchipcount = _s.PlayerRef.GetItemCount(_s.SuH_misc_bloodchip)
	int talibloodchip = math.floor(_s.SuH_realm_taliboost * 0.05)
	int talimaxchip = math.floor(_s.SuH_realm_talistorelvl * 20)
	int processremain = 0
	if _s.SuH_realm_talireitem != none
		processremain = (_f.Replicate_Cost(_s.SuH_realm_talireitem) - _s.SuH_realm_talirepoints)
	endIf
	int upgradetoolcost = math.floor(_s.SuH_realm_talitoollvl * 90)
	int upgradechipstorage = math.floor(_s.SuH_realm_talistorelvl * 50)
	
	int m = _s.SuH_menu_realmtalibench.show(bloodchipcount, talibloodchip, talimaxchip, _s.SuH_realm_talitoollvl, processremain, upgradetoolcost, upgradechipstorage)
	if m == 0 ; Leave Blood Chips
		;	Get potential Blood Chip drop-off, then remove as many as possible to fill this amount from the player and set appropriate boost
		int chipgivemax = (talimaxchip - talibloodchip)
		if bloodchipcount > 0 && chipgivemax > 0
			if bloodchipcount >= chipgivemax
				_s.PlayerRef.removeitem(_s.SuH_misc_bloodchip, chipgivemax)
				_s.SuH_realm_taliboost += (chipgivemax * 20) ; give 20 boost per blood chip
				debug.messagebox("Left behind "+chipgivemax+" Blood Chips for Tali to use.")
			else ; bloodchipcount < chipgivemax
				_s.PlayerRef.removeitem(_s.SuH_misc_bloodchip, bloodchipcount)
				_s.SuH_realm_taliboost += (bloodchipcount * 20) ; give 20 boost per blood chip
				debug.messagebox("Left behind "+bloodchipcount+" Blood Chips for Tali to use.")
			endIf
		else
			debug.messagebox("No Blood Chips to leave behind.")
		endIf
	elseif m == 1 ; Upgrade Tools
		if bloodchipcount > upgradetoolcost
			_s.PlayerRef.removeitem(_s.SuH_misc_bloodchip, upgradetoolcost)
			_s.SuH_realm_talitoollvl += 1
			debug.messagebox("Tali can now upgrade her tools, improving replication speed!")
		else
			debug.messagebox("Not enough Blood Chips to upgrade Tali's Tools.")
		endIf
	elseif m == 2 ; Upgrade Chip Storage
		if bloodchipcount > upgradechipstorage
			_s.PlayerRef.removeitem(_s.SuH_misc_bloodchip, upgradechipstorage)
			_s.SuH_realm_talistorelvl += 1
			debug.messagebox("Tali can now upgrade her Blood Chip Storage!")
		else
			debug.messagebox("Not enough Blood Chips to upgrade Tali's Blood Chip Storage.")
		endIf
	elseif m == 3 ; Check Replicating'
		if _s.SuH_realm_talireitem != none
			debug.messagebox("Tali is currently replicating the "+_s.SuH_realm_talireitem.GetName()+" left behind in her chest.\nWhen complete she will add it to her shop for purchase.")
		else
			debug.messagebox("Tali is not currently replicating anything. If you left items in the chest she will check every hour for new items to work on.")
		endIf
	endIf
endEvent
